/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.registry.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.rei.RoughlyEnoughItemsCoreClient;
import me.shedaniel.rei.api.client.gui.screen.DisplayScreen;
import me.shedaniel.rei.api.client.registry.screen.OverlayRendererProvider;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;

public enum DefaultScreenOverlayRenderer implements OverlayRendererProvider
{
    INSTANCE;

    private final List<Runnable> onRemoved = new ArrayList<Runnable>();

    @Override
    public void onApplied(OverlayRendererProvider.Sink sink) {
        int[] rendered = new int[]{0};
        ClientGuiEvent.ScreenRenderPre renderPre = (screen, matrices, mouseX, mouseY, delta) -> {
            if (RoughlyEnoughItemsCoreClient.shouldReturn(screen)) {
                return EventResult.pass();
            }
            rendered[0] = 0;
            return EventResult.pass();
        };
        ClientGuiEvent.RENDER_PRE.register((Object)renderPre);
        ClientGuiEvent.ContainerScreenRenderBackground renderContainerBg = (screen, matrices, mouseX, mouseY, delta) -> {
            if (RoughlyEnoughItemsCoreClient.shouldReturn((Screen)screen)) {
                return;
            }
            rendered[0] = 1;
            RoughlyEnoughItemsCoreClient.resetFocused((Screen)screen);
            if (!(screen instanceof DisplayScreen)) {
                sink.render(matrices, mouseX, mouseY, delta);
            }
            RoughlyEnoughItemsCoreClient.resetFocused((Screen)screen);
        };
        ClientGuiEvent.RENDER_CONTAINER_BACKGROUND.register((Object)renderContainerBg);
        ClientGuiEvent.ContainerScreenRenderForeground renderContainerFg = (screen, matrices, mouseX, mouseY, delta) -> {
            if (RoughlyEnoughItemsCoreClient.shouldReturn((Screen)screen)) {
                return;
            }
            rendered[0] = 2;
            RoughlyEnoughItemsCoreClient.resetFocused((Screen)screen);
            PoseStack poseStack = RenderSystem.m_157191_();
            poseStack.m_85836_();
            poseStack.m_85837_((double)(-screen.f_97735_), (double)(-screen.f_97736_), 0.0);
            RenderSystem.m_157182_();
            sink.lateRender(matrices, mouseX, mouseY, delta);
            poseStack.m_85849_();
            RenderSystem.m_157182_();
            RoughlyEnoughItemsCoreClient.resetFocused((Screen)screen);
        };
        ClientGuiEvent.RENDER_CONTAINER_FOREGROUND.register((Object)renderContainerFg);
        ClientGuiEvent.ScreenRenderPost renderPost = (screen, matrices, mouseX, mouseY, delta) -> {
            if (RoughlyEnoughItemsCoreClient.shouldReturn(screen) || rendered[0] == 2) {
                return;
            }
            if (screen instanceof AbstractContainerScreen) {
                InternalLogger.getInstance().warn("Screen " + screen.getClass().getName() + " did not render background and foreground! This might cause rendering issues!");
            }
            RoughlyEnoughItemsCoreClient.resetFocused(screen);
            if (rendered[0] == 0 && !(screen instanceof DisplayScreen)) {
                sink.render(matrices, mouseX, mouseY, delta);
            }
            rendered[0] = 1;
            if (rendered[0] == 1) {
                sink.lateRender(matrices, mouseX, mouseY, delta);
            }
            RoughlyEnoughItemsCoreClient.resetFocused(screen);
        };
        ClientGuiEvent.RENDER_POST.register((Object)renderPost);
        this.onRemoved.add(() -> {
            ClientGuiEvent.RENDER_PRE.unregister((Object)renderPre);
            ClientGuiEvent.RENDER_CONTAINER_BACKGROUND.unregister((Object)renderContainerBg);
            ClientGuiEvent.RENDER_CONTAINER_FOREGROUND.unregister((Object)renderContainerFg);
            ClientGuiEvent.RENDER_POST.unregister((Object)renderPost);
        });
    }

    @Override
    public void onRemoved() {
        this.onRemoved.forEach(Runnable::run);
        this.onRemoved.clear();
    }
}

